<?php
// 关闭错误显示，避免HTML错误信息影响JSON输出
error_reporting(0);
ini_set('display_errors', 0);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

function saveUserToFile($userData) {
    $dataFile = 'data.json';

    // 读取现有数据
    if (file_exists($dataFile)) {
        $jsonContent = file_get_contents($dataFile);
        $data = json_decode($jsonContent, true);

        if (json_last_error() !== JSON_ERROR_NONE) {
            $data = ['users' => [], 'last_updated' => null, 'version' => '1.0'];
        }
    } else {
        $data = ['users' => [], 'last_updated' => null, 'version' => '1.0'];
    }

    // 检查用户是否已存在
    $userExists = false;
    foreach ($data['users'] as &$existingUser) {
        if ($existingUser['uid'] === $userData['uid'] && $existingUser['schoolId'] === $userData['schoolId']) {
            // 更新现有用户信息
            $existingUser = array_merge($existingUser, $userData);
            $userExists = true;
            break;
        }
    }

    // 如果用户不存在，添加新用户
    if (!$userExists) {
        $userData['created_at'] = date('Y-m-d H:i:s');
            $data['users'][] = $userData;
    }

    $data['last_updated'] = date('Y-m-d H:i:s');

    // 保存到文件
    if (file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) !== false) {
        return ['success' => true, 'message' => '用户信息保存成功'];
    } else {
        return ['success' => false, 'message' => '保存用户信息失败'];
    }
}

function getUsersFromFile() {
    $dataFile = 'data.json';

    if (file_exists($dataFile)) {
        $jsonContent = file_get_contents($dataFile);
        $data = json_decode($jsonContent, true);

        if (json_last_error() === JSON_ERROR_NONE && isset($data['users'])) {
            return ['success' => true, 'users' => $data['users']];
        }
    }

    return ['success' => true, 'users' => []];
}

function deleteUserFromFile($uid, $schoolId) {
    $dataFile = 'data.json';

    if (!file_exists($dataFile)) {
        return ['success' => false, 'message' => '数据文件不存在'];
    }

    $jsonContent = file_get_contents($dataFile);
    $data = json_decode($jsonContent, true);

    if (json_last_error() !== JSON_ERROR_NONE || !isset($data['users'])) {
        return ['success' => false, 'message' => '数据格式错误'];
    }

    $originalCount = count($data['users']);
    $data['users'] = array_filter($data['users'], function($user) use ($uid, $schoolId) {
        return !($user['uid'] === $uid && $user['schoolId'] === $schoolId);
    });

    if (count($data['users']) < $originalCount) {
        $data['last_updated'] = date('Y-m-d H:i:s');
        $data['users'] = array_values($data['users']); // 重新索引数组

        if (file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) !== false) {
            return ['success' => true, 'message' => '用户删除成功'];
        }
    }

    return ['success' => false, 'message' => '用户删除失败'];
}

try {
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    $action = $_GET['action'] ?? '';

    switch ($action) {
        case 'save':
            if (!$data || !isset($data['uid']) || !isset($data['username']) || !isset($data['schoolId'])) {
                echo json_encode(['success' => false, 'message' => '缺少必要用户信息']);
                exit();
            }
            echo json_encode(saveUserToFile($data));
            break;

        case 'get':
            echo json_encode(getUsersFromFile());
            break;

        case 'delete':
            $uid = $_GET['uid'] ?? '';
            $schoolId = $_GET['schoolId'] ?? '';

            if (!$uid || !$schoolId) {
                echo json_encode(['success' => false, 'message' => '缺少用户标识信息']);
                exit();
            }
            echo json_encode(deleteUserFromFile($uid, $schoolId));
            break;

        default:
            echo json_encode(['success' => false, 'message' => '未知操作']);
    }

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => '服务器错误: ' . $e->getMessage()
    ]);
}
?>