<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>添加用户 - PU校园二维码生成器</title>
    <link rel="stylesheet" href="assets/qrcode.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .container {
            max-width: 500px;
            width: 100%;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 1.8em;
        }

        .subtitle {
            color: #666;
            font-size: 1em;
        }

        .back-link {
            position: absolute;
            top: 30px;
            left: 30px;
            color: white;
            text-decoration: none;
            font-size: 16px;
            background: rgba(0, 0, 0, 0.2);
            padding: 8px 15px;
            border-radius: 20px;
            transition: background 0.3s;
        }

        .back-link:hover {
            background: rgba(0, 0, 0, 0.3);
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            color: #555;
            font-weight: 600;
        }

        select, input[type="text"], input[type="password"] {
            width: 100%;
            padding: 12px;
            border: 2px solid #e1e1e1;
            border-radius: 10px;
            font-size: 16px;
            transition: border-color 0.3s;
        }

        select:focus, input:focus {
            outline: none;
            border-color: #667eea;
        }

        .btn {
            width: 100%;
            padding: 12px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s;
        }

        .btn:hover {
            transform: translateY(-2px);
        }

        .btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }

        .btn-success {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        }

        .btn-success:hover {
            background: linear-gradient(135deg, #218838 0%, #1ea085 100%);
        }

        .loading {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid #f3f3f3;
            border-top: 3px solid #667eea;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-left: 10px;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .alert {
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        @media (max-width: 768px) {
            .container {
                padding: 20px;
                margin: 10px;
            }

            .back-link {
                position: static;
                display: block;
                text-align: center;
                margin-bottom: 20px;
                width: 100%;
                background: rgba(102, 126, 234, 0.2);
                color: #667eea;
            }

            h1 {
                font-size: 1.5em;
            }
        }
    </style>
</head>
<body>
    <a href="index.php" class="back-link">← 返回主页</a>

    <div class="container">
        <div class="header">
            <h1>🎓 添加用户</h1>
            <p class="subtitle">输入学号和密码添加新用户</p>
        </div>

        <div id="alertContainer"></div>

        <div class="form-group">
            <label for="schoolSelect">选择学校</label>
            <select id="schoolSelect" required>
                <option value="">正在加载学校列表...</option>
            </select>
        </div>

        <div class="form-group">
            <label for="username">学号</label>
            <input type="text" id="username" placeholder="请输入学号" required>
        </div>

        <div class="form-group">
            <label for="password">密码</label>
            <input type="password" id="password" placeholder="请输入密码" required>
        </div>

        <button class="btn btn-success" id="loginBtn" onclick="login()">
            添加用户
        </button>

        <div style="margin-top: 20px; text-align: center;">
            <small style="color: #666;">
                📝 提示：用户信息将被安全保存，下次可直接选择使用
            </small>
        </div>
    </div>

    <script src="assets/crypto-js.min.js"></script>
    <script>
        let schools = [];

        // 页面加载时初始化
        window.onload = function() {
            loadSchools();
        };

        // 显示提示信息
        function showAlert(message, type = 'success') {
            const alertContainer = document.getElementById('alertContainer');
            const alert = document.createElement('div');
            alert.className = `alert alert-${type}`;
            alert.textContent = message;
            alertContainer.appendChild(alert);

            setTimeout(() => {
                alert.remove();
            }, 5000);
        }

        // 加载学校列表
        async function loadSchools() {
            try {
                const response = await fetch('get_schools.php');
                const data = await response.json();

                if (data.success) {
                    schools = data.schools;
                    const select = document.getElementById('schoolSelect');
                    select.innerHTML = '<option value="">请选择学校</option>';

                    schools.forEach(school => {
                        const option = document.createElement('option');
                        option.value = school.go_id;
                        option.textContent = school.name;
                        select.appendChild(option);
                    });
                } else {
                    showAlert('获取学校列表失败', 'error');
                    const select = document.getElementById('schoolSelect');
                    select.innerHTML = '<option value="">加载失败，请刷新页面</option>';
                }
            } catch (error) {
                showAlert('网络错误: ' + error.message, 'error');
                const select = document.getElementById('schoolSelect');
                select.innerHTML = '<option value="">网络错误，请检查连接</option>';
            }
        }

        // 登录功能
        async function login() {
            const schoolId = document.getElementById('schoolSelect').value;
            const username = document.getElementById('username').value;
            const password = document.getElementById('password').value;
            const loginBtn = document.getElementById('loginBtn');

            if (!schoolId || !username || !password) {
                showAlert('请填写完整信息', 'error');
                return;
            }

            loginBtn.innerHTML = '添加中<span class="loading"></span>';
            loginBtn.disabled = true;

            try {
                const response = await fetch('login.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        sid: parseInt(schoolId),
                        device: 'pc',
                        userName: username,
                        password: password
                    })
                });

                const data = await response.json();

                if (data.code === 0) {
                    const userInfo = {
                        uid: data.data.baseUserInfo.id,
                        username: data.data.baseUserInfo.username,
                        nickname: data.data.baseUserInfo.nickname,
                        className: data.data.baseUserInfo.className,
                        schoolId: schoolId,
                        token: data.data.token,
                        realname: data.data.baseUserInfo.realname
                    };

                    // 保存用户信息
                    const saveResponse = await fetch('save_user.php?action=save', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify(userInfo)
                    });

                    const saveData = await saveResponse.json();

                    if (saveData.success) {
                        showAlert('用户添加成功！即将跳转到主页...', 'success');

                        // 延迟跳转到主页
                        setTimeout(() => {
                            window.location.href = 'index.php';
                        }, 2000);
                    } else {
                        showAlert('登录成功但保存用户失败', 'error');
                    }
                } else {
                    showAlert(data.message || '登录失败，请检查学号和密码', 'error');
                }
            } catch (error) {
                showAlert('网络错误: ' + error.message, 'error');
            } finally {
                loginBtn.innerHTML = '添加用户';
                loginBtn.disabled = false;
            }
        }

        // 回车键提交
        document.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                login();
            }
        });
    </script>
</body>
</html>