<?php
// 关闭错误显示，避免HTML错误信息影响JSON输出
error_reporting(0);
ini_set('display_errors', 0);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

try {
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    if (!$data) {
        echo json_encode([
            'code' => -1,
            'message' => '请求数据格式错误'
        ]);
        exit();
    }

    $requiredFields = ['sid', 'device', 'userName', 'password'];
    foreach ($requiredFields as $field) {
        if (!isset($data[$field]) || empty($data[$field])) {
            echo json_encode([
                'code' => -1,
                'message' => "缺少必要字段: {$field}"
            ]);
            exit();
        }
    }

    $apiUrl = 'https://apis.pocketuni.net/uc/user/login';

    $postData = json_encode([
        'sid' => $data['sid'],
        'device' => $data['device'],
        'userName' => $data['userName'],
        'password' => $data['password']
    ]);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Content-Length: ' . strlen($postData)
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    curl_close($ch);

    if ($curlError) {
        echo json_encode([
            'code' => -1,
            'message' => '网络请求失败: ' . $curlError
        ]);
        exit();
    }

    if ($httpCode !== 200) {
        echo json_encode([
            'code' => -1,
            'message' => 'API请求失败，HTTP状态码: ' . $httpCode
        ]);
        exit();
    }

    $result = json_decode($response, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode([
            'code' => -1,
            'message' => '解析响应数据失败'
        ]);
        exit();
    }

    echo $response;

} catch (Exception $e) {
    echo json_encode([
        'code' => -1,
        'message' => '服务器错误: ' . $e->getMessage()
    ]);
}
?>