<?php
session_start();

// 检查是否有用户数据
$hasUsers = false;
if (file_exists('data.json')) {
    $jsonContent = file_get_contents('data.json');
    $data = json_decode($jsonContent, true);
    if (json_last_error() === JSON_ERROR_NONE && isset($data['users']) && !empty($data['users'])) {
        $hasUsers = true;
    }
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PU校园二维码生成器</title>
    <link rel="stylesheet" href="assets/qrcode.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 2em;
        }

        .subtitle {
            color: #666;
            font-size: 1.1em;
        }

        .add-user-btn {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            margin-bottom: 30px;
        }

        .add-user-btn:hover {
            background: linear-gradient(135deg, #218838 0%, #1ea085 100%);
        }

        .user-list {
            margin-top: 20px;
        }

        .user-item {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 15px;
            cursor: pointer;
            transition: all 0.3s;
            border: 2px solid transparent;
        }

        .user-item:hover {
            background: #e9ecef;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }

        .user-item.selected {
            border-color: #667eea;
            background: #f0f3ff;
        }

        .user-info {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
            gap: 10px;
            font-size: 14px;
        }

        .user-actions {
            margin-top: 10px;
            display: flex;
            gap: 10px;
        }

        .delete-btn {
            background: #dc3545;
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 12px;
        }

        .delete-btn:hover {
            background: #c82333;
        }

        .qrcode-section {
            display: none;
            margin-top: 30px;
            text-align: center;
            padding: 20px;
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        }

        #qrcode {
            display: inline-block;
            padding: 20px;
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            margin: 20px 0;
        }

        .timer {
            font-size: 24px;
            font-weight: bold;
            color: #667eea;
            margin: 20px 0;
        }

        .refresh-btn {
            background: #28a745;
            margin-top: 15px;
        }

        .refresh-btn:hover {
            background: #218838;
        }

        .loading {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid #f3f3f3;
            border-top: 3px solid #667eea;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-left: 10px;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .alert {
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #666;
        }

        .empty-state h3 {
            font-size: 1.5em;
            margin-bottom: 15px;
            color: #333;
        }

        .btn {
            width: 100%;
            padding: 12px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s;
        }

        .btn:hover {
            transform: translateY(-2px);
        }

        .btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }

        @media (max-width: 768px) {
            .container {
                padding: 20px;
                margin: 10px;
            }

            h1 {
                font-size: 1.5em;
            }

            .user-info {
                grid-template-columns: 1fr;
                gap: 5px;
            }

            #qrcode {
                padding: 15px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🎓 PU校园二维码生成器</h1>
            <p class="subtitle">选择用户账号生成登录二维码</p>
        </div>

        <div id="alertContainer"></div>

        <?php if ($hasUsers): ?>
        <button class="btn add-user-btn" onclick="window.location.href='register.php'">
            ➕ 添加新用户
        </button>
        <?php endif; ?>

        <div class="user-list" id="userList">
            <h3>已保存的用户</h3>
            <div id="userContainer"></div>
        </div>

        <?php if (!$hasUsers): ?>
        <div class="empty-state">
            <h3>📝 还没有用户信息</h3>
            <p>点击下方按钮添加第一个用户账号</p>
            <button class="btn add-user-btn" onclick="window.location.href='register.php'" style="margin-top: 20px;">
                ➕ 添加用户
            </button>
        </div>
        <?php endif; ?>

        <div class="qrcode-section" id="qrcodeSection">
            <h3>用户信息</h3>
            <div class="user-info" id="selectedUserInfo"></div>

            <div id="qrcode"></div>

            <div class="timer" id="timer">剩余时间: 30秒</div>

            <button class="btn refresh-btn" onclick="generateQRCode()">
                🔄 刷新二维码
            </button>
        </div>
    </div>

    <script src="assets/crypto-js.min.js"></script>
    <script src="assets/qrcode.min.js"></script>
    <script>
        let selectedUser = null;
        let timerInterval = null;
        let users = [];

        // 页面加载时初始化
        window.onload = function() {
            loadUsers();
        };

        // 显示提示信息
        function showAlert(message, type = 'success') {
            const alertContainer = document.getElementById('alertContainer');
            const alert = document.createElement('div');
            alert.className = `alert alert-${type}`;
            alert.textContent = message;
            alertContainer.appendChild(alert);

            setTimeout(() => {
                alert.remove();
            }, 5000);
        }

        // 加载用户列表
        async function loadUsers() {
            try {
                const response = await fetch('save_user.php?action=get');
                const data = await response.json();

                if (data.success) {
                    users = data.users;
                    displayUserList();

                    // 如果没有用户，显示添加按钮
                    if (users.length === 0) {
                        document.getElementById('userList').style.display = 'none';
                    }
                } else {
                    showAlert('加载用户列表失败', 'error');
                }
            } catch (error) {
                showAlert('网络错误: ' + error.message, 'error');
            }
        }

        // 显示用户列表
        function displayUserList() {
            const userContainer = document.getElementById('userContainer');
            userContainer.innerHTML = '';

            if (users.length === 0) {
                return;
            }

            users.forEach((user, index) => {
                const userItem = document.createElement('div');
                userItem.className = 'user-item';
                userItem.onclick = () => selectUser(index);

                const userActions = document.createElement('div');
                userActions.className = 'user-actions';
                userActions.innerHTML = `
                    <button class="delete-btn" onclick="deleteUser(${index}, event)">删除</button>
                `;
                userActions.onclick = (e) => e.stopPropagation();

                const userInfo = document.createElement('div');
                userInfo.className = 'user-info';
                userInfo.innerHTML = `
                    <div><strong>学号:</strong> ${user.username}</div>
                    <div><strong>姓名:</strong> ${user.nickname}</div>
                    <div><strong>班级:</strong> ${user.className}</div>
                `;

                userItem.appendChild(userInfo);
                userItem.appendChild(userActions);
                userContainer.appendChild(userItem);
            });
        }

        // 删除用户
        async function deleteUser(index, event) {
            event.stopPropagation();

            if (!confirm('确定要删除这个用户吗？')) {
                return;
            }

            const user = users[index];

            try {
                const response = await fetch(`save_user.php?action=delete&uid=${user.uid}&schoolId=${user.schoolId}`);
                const data = await response.json();

                if (data.success) {
                    showAlert('用户删除成功', 'success');
                    users.splice(index, 1);
                    displayUserList();

                    // 如果没有用户了，显示空状态
                    if (users.length === 0) {
                        document.getElementById('userList').style.display = 'none';
                        document.getElementById('qrcodeSection').style.display = 'none';
                        location.reload(); // 重新加载页面显示空状态
                    }
                } else {
                    showAlert(data.message || '删除失败', 'error');
                }
            } catch (error) {
                showAlert('网络错误: ' + error.message, 'error');
            }
        }

        // 选择用户
        function selectUser(index) {
            selectedUser = users[index];

            // 更新选中状态
            document.querySelectorAll('.user-item').forEach((item, i) => {
                if (i === index) {
                    item.classList.add('selected');
                } else {
                    item.classList.remove('selected');
                }
            });

            // 显示用户信息
            document.getElementById('selectedUserInfo').innerHTML = `
                <div><strong>UID:</strong> ${selectedUser.uid}</div>
                <div><strong>学号:</strong> ${selectedUser.username}</div>
                <div><strong>姓名:</strong> ${selectedUser.nickname}</div>
            `;

            // 生成二维码
            generateQRCode();
        }

        // DES加密函数
        function desEncrypt(text) {
            const key = CryptoJS.enc.Utf8.parse("TG123!@#qazDES*&^956367encode7788TR");
            const encrypted = CryptoJS.DES.encrypt(text, key, {
                mode: CryptoJS.mode.ECB,
                padding: CryptoJS.pad.Pkcs7
            });
            return encrypted.toString();
        }

        // 生成二维码
        function generateQRCode() {
            if (!selectedUser) return;

            // 清除之前的定时器
            if (timerInterval) {
                clearInterval(timerInterval);
            }

            const timestamp = Date.now();
            const qrString = `xyhui://user/${selectedUser.uid}/${timestamp}/${selectedUser.username}`;
            const encrypted = desEncrypt(qrString);

            // 清除之前的二维码
            document.getElementById('qrcode').innerHTML = '';

            // 生成新的二维码
            new QRCode(document.getElementById("qrcode"), {
                text: encrypted,
                width: 256,
                height: 256,
                colorDark: "#000000",
                colorLight: "#ffffff",
                correctLevel: QRCode.CorrectLevel.H
            });

            // 显示二维码区域
            document.getElementById('qrcodeSection').style.display = 'block';

            // 开始倒计时
            let countdown = 30;
            const timerElement = document.getElementById('timer');

            timerInterval = setInterval(() => {
                countdown--;
                timerElement.textContent = `剩余时间: ${countdown}秒`;

                if (countdown <= 0) {
                    clearInterval(timerInterval);
                    generateQRCode(); // 自动刷新
                }
            }, 1000);
        }
    </script>
</body>
</html>