<?php
// 关闭错误显示，避免HTML错误信息影响JSON输出
error_reporting(0);
ini_set('display_errors', 0);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

try {
    $apiUrl = 'https://pocketuni.net/index.php?app=api&mod=Sitelist&act=getSchools';

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode === 200 && $response !== false) {
        $schools = json_decode($response, true);

        if (json_last_error() === JSON_ERROR_NONE && is_array($schools)) {
            echo json_encode([
                'success' => true,
                'schools' => $schools
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => '解析学校数据失败'
            ]);
        }
    } else {
        echo json_encode([
            'success' => false,
            'message' => '请求失败，HTTP状态码: ' . $httpCode
        ]);
    }

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => '服务器错误: ' . $e->getMessage()
    ]);
}
?>