# PU校园二维码生成器

这是一个基于PHP和JavaScript的PU校园二维码生成系统，用于学习和研究目的。

## 功能特性

- 🎓 支持多学校登录
- 👥 多用户信息管理
- 📱 完全响应式设计，支持移动端
- 🔐 前端DES加密
- 📊 实时二维码生成
- ⏰ 30秒自动刷新
- 💾 本地数据存储
- 🔄 智能页面跳转
- 🎨 美观的用户界面

## 系统架构

### 前端功能
- **主页(index.php)**: 用户选择和管理界面
- **注册页(register.php)**: 添加新用户界面
- 学校列表获取和选择
- 用户登录界面
- 用户信息管理（添加、选择、删除）
- DES加密实现
- 二维码生成
- 30秒倒计时自动刷新

### 后端API
- `get_schools.php` - 获取学校列表
- `login.php` - 处理用户登录
- `save_user.php` - 用户数据管理

### 数据存储
- `data.json` - 本地JSON文件存储用户信息
- LocalStorage - 浏览器端缓存

### 静态资源
- `assets/crypto-js.min.js` - 加密库
- `assets/qrcode.min.js` - 二维码生成库
- `assets/qrcode.min.css` - 样式文件

## 安装和部署

### 环境要求
- PHP 7.0+
- Web服务器 (Apache/Nginx)
- cURL扩展
- JSON扩展

### 部署步骤
1. 将所有文件上传到Web服务器目录
2. 确保`data.json`文件可写权限
3. 确保`assets`目录可读
4. 访问`index.php`开始使用

### 目录结构
```
├── index.php          # 主页面（用户选择界面）
├── register.php       # 注册页面（添加新用户）
├── get_schools.php    # 学校列表API
├── login.php          # 登录API
├── save_user.php      # 用户数据API
├── data.json          # 数据存储文件
├── assets/            # 静态资源目录
│   ├── crypto-js.min.js
│   ├── qrcode.min.js
│   └── qrcode.min.css
└── README.md          # 说明文档
```

## 使用说明

### 1. 首次使用流程
1. **没有用户时**: 访问`index.php`会自动跳转到`register.php`
2. **添加用户**: 在注册页面选择学校、输入学号密码
3. **自动跳转**: 添加成功后自动跳回主页

### 2. 日常使用流程
1. **选择用户**: 在主页点击已保存的用户
2. **生成二维码**: 系统自动生成加密二维码
3. **自动刷新**: 30秒后自动刷新二维码

### 3. 管理功能
- **添加用户**: 点击"添加新用户"按钮
- **删除用户**: 在用户列表中点击删除按钮
- **切换用户**: 直接点击不同用户切换

## 技术实现

### 页面跳转逻辑
```php
// 主页逻辑
if (!$hasUsers && !isset($_GET['force'])) {
    header('Location: register.php');
    exit();
}
```

### 加密算法
```javascript
// DES, ECB, PKCS7, Base64
const key = "TG123!@#qazDES*&^956367encode7788TR";
const encrypted = CryptoJS.DES.encrypt(text, key, {
    mode: CryptoJS.mode.ECB,
    padding: CryptoJS.pad.Pkcs7
});
```

### 二维码格式
```
xyhui://user/{uid}/{timestamp}/{username}
```

### API接口

#### 获取学校列表
```
GET get_schools.php
```

#### 用户登录
```
POST login.php
Content-Type: application/json

{
    "sid": "学校ID",
    "device": "pc",
    "userName": "学号",
    "password": "密码"
}
```

#### 用户数据管理
```
POST save_user.php?action={save|get|delete}
```

## 新版本特性

### v2.0 (2024)
- ✨ **智能页面跳转**: 无用户时自动跳转到注册页
- 🎨 **全新UI设计**: 美观的渐变背景和卡片式布局
- 📱 **完全响应式**: 优化移动端体验
- 💾 **本地静态资源**: 不再依赖外部CDN
- 🔄 **增强的用户管理**: 支持添加、删除、切换用户
- ⚡ **性能优化**: 更快的加载速度

## 安全说明

⚠️ **重要声明**
- 本系统仅用于教育学习和研究目的
- 请遵守相关法律法规和学校规定
- 不得用于商业用途或非法活动

## 注意事项

1. 请确保网络连接正常
2. 建议使用现代浏览器
3. 移动端访问效果更佳
4. 数据存储在本地，请注意备份
5. 首次使用需要添加至少一个用户

## 故障排除

### 常见问题
- **页面跳转问题**: 检查PHP Session是否正常工作
- **静态资源加载失败**: 确认assets目录权限设置
- **网络请求失败**: 检查网络连接和防火墙设置
- **登录失败**: 确认学号密码正确
- **二维码不显示**: 检查JavaScript是否启用

### 调试模式
打开浏览器开发者工具查看控制台日志

## 更新日志

### v2.0 (2024)
- 重构页面架构，分离注册和选择功能
- 优化用户界面，提升用户体验
- 本地化所有静态资源，提高加载速度
- 增强用户管理功能
- 修复已知bug

### v1.0 (2024)
- 初始版本发布
- 基础功能实现
- 响应式设计
- 多用户支持

## 许可证

仅供学习和研究使用

## 联系方式

如有问题或建议，请通过以下方式联系：
- 提交Issue
- 发送邮件

---

**免责声明**: 本系统仅供学习研究使用，请勿用于非法用途。使用者需自行承担使用风险。